﻿
using System.IO;
namespace Microscopic_Traffic_Simulator___Model.Utilities
{
    /// <summary>
    /// Class for storing line data to text files.
    /// </summary>
    class FileDataStore
    {
        /// <summary>
        /// Path to file store the data.
        /// </summary>
        private string path;

        /// <summary>
        /// Class constructor.
        /// </summary>
        /// <param name="path">Path to file store the data.</param>
        internal FileDataStore(string path)
        {
            this.path = path;
        }

        /// <summary>
        /// Gets stream writer to write data while creating a unique file. If file exists then find suffix when
        /// filename is not used.
        /// </summary>
        /// <returns>Stream writer ready to write into.</returns>
        internal StreamWriter GetStreamWriter()
        {
            string path = this.path;
            if (File.Exists(path))
            {
                int suffixNumber = 1;
                do
                {
                    string fileNameWithoutExtension = Path.GetFileNameWithoutExtension(this.path);
                    fileNameWithoutExtension += "_" + suffixNumber;
                    path = Path.GetDirectoryName(this.path) + fileNameWithoutExtension + Path.GetExtension(this.path);
                    suffixNumber++;
                } while (File.Exists(path));
            }

            return new StreamWriter(path);            
        }
    }
}
